<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/constants.php';
$code = $_GET['c'] ?? null;
if (!$code || !preg_match('/^[a-zA-Z0-9]{6}$/', $code)) { http_response_code(404); die('URL invalide'); }
try {
    $stmt = $pdo->prepare("SELECT id, target_url, is_active, expires_at FROM short_urls WHERE short_code = :code");
    $stmt->execute([':code' => $code]);
    $url = $stmt->fetch();
    if (!$url) { http_response_code(404); die('URL introuvable'); }
    if (!$url['is_active']) { http_response_code(410); die('Lien désactivé'); }
    if ($url['expires_at'] && strtotime($url['expires_at']) < time()) { http_response_code(410); die('Lien expiré'); }
    $stmt = $pdo->prepare("INSERT INTO short_url_clicks (short_url_id, ip_address, user_agent, referer) VALUES (:id, :ip, :ua, :referer)");
    $stmt->execute([':id' => $url['id'], ':ip' => $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0', ':ua' => $_SERVER['HTTP_USER_AGENT'] ?? null, ':referer' => $_SERVER['HTTP_REFERER'] ?? null]);
    $pdo->prepare("UPDATE short_urls SET clicks_count = clicks_count + 1 WHERE id = :id")->execute([':id' => $url['id']]);
    header('Location: ' . $url['target_url'], true, 302);
    exit;
} catch (Exception $e) {
    error_log('Short URL error: ' . $e->getMessage());
    http_response_code(500);
    die('Erreur serveur');
}
