<?php
function slugify($text,$divider='-'){$text=preg_replace('~[^\pL\d]+~u',$divider,$text);$text=iconv('utf-8','us-ascii//TRANSLIT',$text);$text=preg_replace('~[^-\w]+~','',$text);$text=trim($text,$divider);$text=preg_replace('~-+~',$divider,$text);return empty($text=strtolower($text))?'n-a':$text;}
function get_event_slug($event_id){global $pdo;$stmt=$pdo->prepare("SELECT slug FROM events WHERE id=:id");$stmt->execute([':id'=>$event_id]);$event=$stmt->fetch();return $event?$event['slug']:null;}
function log_to_file($type,$message,$level='info'){@file_put_contents(LOGS_PATH.'/'.$type.'.log',"[".date('Y-m-d H:i:s')."] [$level] $message\n",FILE_APPEND);}
function redirect($url,$code=302){if(!headers_sent()){header("Location: $url",true,$code);exit;}}
function e($text){return htmlspecialchars($text??'',ENT_QUOTES,'UTF-8');}
function format_date($date,$format='d/m/Y à H:i'){if(empty($date))return'';$timestamp=is_numeric($date)?$date:strtotime($date);return date($format,$timestamp);}
function time_ago($datetime){$diff=time()-(is_numeric($datetime)?$datetime:strtotime($datetime));if($diff<60)return'À l\'instant';if($diff<3600)return floor($diff/60).' min';if($diff<86400)return floor($diff/3600).' h';if($diff<604800)return floor($diff/86400).' j';if($diff<2592000)return floor($diff/604800).' sem';if($diff<31536000)return floor($diff/2592000).' mois';return floor($diff/31536000).' an'.(floor($diff/31536000)>1?'s':'');}
function generate_token($length=32){return bin2hex(random_bytes($length));}
function is_logged_in(){return isset($_SESSION['user_id'])&&!empty($_SESSION['user_id']);}
function get_current_user_id(){return $_SESSION['user_id']??null;}
function get_current_user(){if(!is_logged_in())return null;global $pdo;$stmt=$pdo->prepare("SELECT * FROM users WHERE id=:id");$stmt->execute([':id'=>get_current_user_id()]);return $stmt->fetch();}
function has_role($role){$user=get_current_user();return $user&&$user['role']===$role;}
function require_auth(){if(!is_logged_in()){$_SESSION['redirect_after_login']=$_SERVER['REQUEST_URI'];redirect('/auth/login');}}
function require_admin(){require_auth();if(!has_role(ROLE_ADMIN)){http_response_code(403);die('Accès refusé');}}
function format_number($num){if($num>=1000000)return round($num/1000000,1).'M';if($num>=1000)return round($num/1000,1).'k';return(string)$num;}
function format_filesize($bytes){$units=['B','KB','MB','GB'];$bytes=max($bytes,0);$pow=floor(($bytes?log($bytes):0)/log(1024));$pow=min($pow,count($units)-1);$bytes/=(1<<(10*$pow));return round($bytes,2).' '.$units[$pow];}
function get_client_ip(){if(!empty($_SERVER['HTTP_CLIENT_IP']))return $_SERVER['HTTP_CLIENT_IP'];elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR']))return $_SERVER['HTTP_X_FORWARDED_FOR'];else return $_SERVER['REMOTE_ADDR']??'0.0.0.0';}
function json_response($data,$status=200){http_response_code($status);header('Content-Type: application/json; charset=utf-8');echo json_encode($data,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);exit;}
function json_error($code,$message,$status=400){json_response(['success'=>false,'error'=>['code'=>$code,'message'=>$message]],$status);}
function json_success($data=[],$meta=[]){$response=['success'=>true];if(!empty($data))$response['data']=$data;if(!empty($meta))$response['meta']=$meta;json_response($response);}
