<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
function send_email($params){global $pdo;$config=require __DIR__.'/../config/email.php';require_once __DIR__.'/../vendor/phpmailer/phpmailer/src/PHPMailer.php';require_once __DIR__.'/../vendor/phpmailer/phpmailer/src/SMTP.php';require_once __DIR__.'/../vendor/phpmailer/phpmailer/src/Exception.php';$mail=new PHPMailer(true);$log_data=['user_id'=>$params['user_id']??null,'recipient_email'=>$params['to'],'email_type'=>$params['type']??'other','subject'=>$params['subject'],'status'=>'failed','smtp_code'=>null,'smtp_message'=>null,'error_details'=>null];try{$mail->isSMTP();$mail->Host=$config['smtp']['host'];$mail->SMTPAuth=true;$mail->Username=$config['smtp']['username'];$mail->Password=$config['smtp']['password'];$mail->SMTPSecure=$config['smtp']['encryption'];$mail->Port=$config['smtp']['port'];$mail->CharSet='UTF-8';$mail->setFrom($config['smtp']['from_email'],$config['smtp']['from_name']);$mail->addAddress($params['to']);$mail->isHTML(true);$mail->Subject=$params['subject'];$mail->Body=render_email_template($params['template'],$params['vars']??[]);$result=$mail->send();if($result){$log_data['status']='sent';$log_data['smtp_code']='250';$log_data['smtp_message']='Message sent successfully';}log_email($log_data);log_to_file('email',"SUCCESS: Email '{$params['type']}' sent to {$params['to']}");return true;}catch(Exception $e){$log_data['error_details']=$mail->ErrorInfo;$log_data['smtp_message']=$e->getMessage();if(preg_match('/SMTP Error: (\d+)/',$mail->ErrorInfo,$matches)){$log_data['smtp_code']=$matches[1];}log_email($log_data);log_to_file('email',"ERROR: Email '{$params['type']}' to {$params['to']} - {$mail->ErrorInfo}",'error');return false;}}
function log_email($data){global $pdo;try{$stmt=$pdo->prepare("INSERT INTO email_logs (user_id, recipient_email, email_type, subject, status, smtp_code, smtp_message, error_details) VALUES (:user_id, :recipient, :type, :subject, :status, :code, :message, :error)");$stmt->execute([':user_id'=>$data['user_id'],':recipient'=>$data['recipient_email'],':type'=>$data['email_type'],':subject'=>$data['subject'],':status'=>$data['status'],':code'=>$data['smtp_code'],':message'=>$data['smtp_message'],':error'=>$data['error_details']]);}catch(Exception $e){log_to_file('email','Failed to log email: '.$e->getMessage(),'error');}}
function render_email_template($template,$vars=[]){$config=require __DIR__.'/../config/email.php';$template_path=$config['templates_path'].$template.'.php';if(!file_exists($template_path))throw new Exception("Template email introuvable: $template");extract($vars);ob_start();include $template_path;return ob_get_clean();}
function is_valid_email($email){return filter_var($email,FILTER_VALIDATE_EMAIL)!==false;}
