<?php
define('ROOT_PATH', dirname(__DIR__));
define('PUBLIC_PATH', ROOT_PATH . '/public');
define('UPLOAD_PATH', PUBLIC_PATH . '/uploads');
define('LOGS_PATH', ROOT_PATH . '/logs');
define('BASE_URL', getenv('BASE_URL') ?: 'https://ales.city');
define('ASSETS_URL', BASE_URL . '/assets');
define('UPLOADS_URL', BASE_URL . '/uploads');
define('UPLOAD_MAX_SIZE', (int)(getenv('UPLOAD_MAX_SIZE') ?: 10485760));
define('UPLOAD_ALLOWED_MIMES', explode(',', getenv('UPLOAD_ALLOWED_MIMES') ?: 'image/jpeg,image/png,image/webp'));
define('UPLOAD_ALLOWED_EXTENSIONS', explode(',', getenv('UPLOAD_ALLOWED_EXTENSIONS') ?: 'jpg,jpeg,png,webp'));
define('THUMB_SIZE', 300);
define('MEDIUM_SIZE', 800);
define('LARGE_SIZE', 1920);
define('JPEG_QUALITY', 85);
define('ITEMS_PER_PAGE', (int)(getenv('ITEMS_PER_PAGE') ?: 20));
define('MAX_ITEMS_PER_PAGE', (int)(getenv('MAX_ITEMS_PER_PAGE') ?: 100));
define('PASSWORD_MIN_LENGTH', (int)(getenv('PASSWORD_MIN_LENGTH') ?: 8));
define('SESSION_LIFETIME', (int)(getenv('SESSION_LIFETIME') ?: 7200));
define('TOKEN_EXPIRY_EMAIL', 86400);
define('TOKEN_EXPIRY_PASSWORD', 3600);
define('API_TOKEN_ACCESS_EXPIRY', 3600);
define('API_TOKEN_REFRESH_EXPIRY', 2592000);
define('RATE_LIMIT_UPLOAD', (int)(getenv('RATE_LIMIT_UPLOAD') ?: 5));
define('RATE_LIMIT_LIKE', (int)(getenv('RATE_LIMIT_LIKE') ?: 50));
define('RATE_LIMIT_COMMENT', (int)(getenv('RATE_LIMIT_COMMENT') ?: 20));
define('RATE_LIMIT_REPORT', (int)(getenv('RATE_LIMIT_REPORT') ?: 10));
define('ROLE_USER', 'user');
define('ROLE_PRO', 'pro');
define('ROLE_ADMIN', 'admin');
define('STATUS_PENDING', 'pending');
define('STATUS_ACTIVE', 'active');
define('STATUS_BANNED', 'banned');
define('MODERATION_PENDING', 'pending');
define('MODERATION_APPROVED', 'approved');
define('MODERATION_REJECTED', 'rejected');
define('SCORE_PHOTO_WEIGHT', 1);
define('SCORE_LIKE_WEIGHT', 3);
