<?php
echo "=== VÉRIFICATION INSTALLATION ALÈS.CITY v0.1.1 ===\n\n";
$errors = [];
$warnings = [];

// 1. Version PHP
echo "1. Version PHP : ";
if (version_compare(PHP_VERSION, '8.0.0', '>=')) {
    echo "✓ " . PHP_VERSION . "\n";
} else {
    echo "✗ " . PHP_VERSION . " (requis: 8.0+)\n";
    $errors[] = "Version PHP insuffisante";
}

// 2. Extensions PHP
echo "2. Extensions PHP :\n";
$required_extensions = ['pdo', 'pdo_mysql', 'mbstring', 'gd', 'openssl', 'json'];
foreach ($required_extensions as $ext) {
    echo "   - $ext : ";
    if (extension_loaded($ext)) {
        echo "✓\n";
    } else {
        echo "✗\n";
        $errors[] = "Extension $ext manquante";
    }
}

// 3. Fichier .env
echo "3. Configuration :\n";
echo "   - .env : ";
if (file_exists(__DIR__ . '/.env')) {
    echo "✓\n";
    
    // Vérifier présence DB_PORT
    $env_content = file_get_contents(__DIR__ . '/.env');
    echo "   - DB_PORT : ";
    if (strpos($env_content, 'DB_PORT') !== false) {
        echo "✓\n";
    } else {
        echo "⚠ (non défini, utilisera 3306 par défaut)\n";
        $warnings[] = "DB_PORT non défini dans .env";
    }
} else {
    echo "✗ (copier .env.example vers .env)\n";
    $errors[] = "Fichier .env manquant";
}

// 4. Permissions
echo "4. Permissions dossiers :\n";
$writable_dirs = [
    'logs',
    'public/uploads',
    'public/uploads/original',
    'public/uploads/large',
    'public/uploads/medium',
    'public/uploads/thumb',
    'public/uploads/qr'
];

foreach ($writable_dirs as $dir) {
    echo "   - $dir : ";
    if (is_writable(__DIR__ . '/' . $dir)) {
        echo "✓\n";
    } else {
        echo "✗ (chmod 755 requis)\n";
        $warnings[] = "Dossier $dir non inscriptible";
    }
}

// 5. Vendor
echo "5. Dépendances Composer :\n";
echo "   - vendor/ : ";
if (is_dir(__DIR__ . '/vendor')) {
    echo "✓\n";
} else {
    echo "✗ (exécuter: composer install)\n";
    $errors[] = "Dépendances Composer manquantes";
}

// 6. Base de données (si .env existe)
if (file_exists(__DIR__ . '/.env')) {
    echo "6. Connexion base de données :\n";
    try {
        require_once __DIR__ . '/config/database.php';
        
        // Afficher config de connexion
        echo "   - Hôte : " . getenv('DB_HOST') . "\n";
        echo "   - Port : " . (getenv('DB_PORT') ?: '3306') . "\n";
        echo "   - Base : " . getenv('DB_NAME') . "\n";
        
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM information_schema.tables WHERE table_schema = DATABASE()");
        $result = $stmt->fetch();
        $table_count = $result['count'];
        
        echo "   - Connexion : ✓\n";
        echo "   - Tables : ";
        if ($table_count == 18) {
            echo "✓ ($table_count/18)\n";
        } else {
            echo "⚠ ($table_count/18 - importer database/schema.sql)\n";
            $warnings[] = "Schéma DB incomplet ($table_count/18 tables)";
        }
        
    } catch (Exception $e) {
        echo "   - Connexion : ✗\n";
        echo "   - Erreur : " . $e->getMessage() . "\n";
        $errors[] = "Connexion DB impossible";
    }
}

// Résumé
echo "\n=== RÉSUMÉ ===\n";
if (count($errors) === 0 && count($warnings) === 0) {
    echo "✓ Installation complète et fonctionnelle !\n";
    echo "Version : 0.1.1\n";
    exit(0);
} else {
    if (count($errors) > 0) {
        echo "\n❌ ERREURS (" . count($errors) . ") :\n";
        foreach ($errors as $error) {
            echo "   - $error\n";
        }
    }
    
    if (count($warnings) > 0) {
        echo "\n⚠️  AVERTISSEMENTS (" . count($warnings) . ") :\n";
        foreach ($warnings as $warning) {
            echo "   - $warning\n";
        }
    }
    
    echo "\nCorrigez les erreurs avant de continuer.\n";
    exit(1);
}
