# ALÈS.CITY v0.1.1

Plateforme de partage de photos d'événements et lieux à Alès (Gard).

## 🚀 Installation Rapide

```bash
# 1. Uploader fichiers sur serveur
# 2. Pointer domaine vers /public
# 3. Copier .env
cp .env.example .env
# 4. Éditer .env avec vos credentials
# 5. Créer base MySQL et importer
mysql -h serveur -P port -u user -p base < database/schema.sql
# 6. Installer Composer
composer install --no-dev
# 7. Permissions
chmod -R 755 public/uploads logs
# 8. Vérifier
php check_install.php
```

## 📋 Configuration .env

```ini
DB_HOST=votre-serveur.mysql.db
DB_PORT=3306  # ← NOUVEAU v0.1.1 : Support port personnalisé
DB_NAME=votre_base
DB_USER=votre_user
DB_PASSWORD=votre_password

APP_URL=https://votre-domaine.com
SMTP_USERNAME=noreply@votre-domaine.com
SMTP_PASSWORD=votre_password_email
```

## ✨ Nouveautés v0.1.1

- ✅ **Support port MySQL personnalisé** (DB_PORT)
- ✅ Amélioration check_install.php
- ✅ Documentation mise à jour

## 📦 Contenu

- 18 tables base de données
- Configuration email SMTP OVH
- QR codes & Short URLs
- Sécurité (CSRF, XSS, SQL injection)
- Documentation complète

## 🔧 Configuration DNS (Emails)

```
SPF:   v=spf1 include:mx.ovh.com ~all
DKIM:  Activer dans panneau OVH
DMARC: v=DMARC1; p=quarantine; rua=mailto:postmaster@votre-domaine.com
```

## 📁 Structure

```
ales.city/
├── public/          # Document root
├── api/v1/          # API REST
├── config/          # Configuration
├── lib/             # Bibliothèques
├── pages/           # Pages front
├── admin/           # Back-office
├── templates/       # Templates HTML/Email
├── database/        # Schema SQL
├── logs/            # Logs
└── vendor/          # Dépendances
```

## 🆘 Dépannage

**Erreur connexion DB ?**
- Vérifier credentials dans .env
- Vérifier DB_PORT si port non standard
- Tester : `mysql -h HOST -P PORT -u USER -p`

**Emails non envoyés ?**
- Consulter logs/email.log
- Vérifier SPF/DKIM/DMARC
- Tester avec mail-tester.com

## 📞 Support

- Exécuter : `php check_install.php`
- Consulter : logs/error.log
- Documentation : INSTALLATION.md

---

**Version : 0.1.1 | Date : 11 février 2026**
