# 🚀 DÉMARRAGE RAPIDE v0.1.1

## Installation en 10 minutes

### 1. Upload fichiers
FTP vers votre hébergement OVH

### 2. Pointer domaine
Manager OVH → Multisite → Dossier racine : `public`

### 3. Base de données
- Créer base MySQL
- Importer database/schema.sql

### 4. Configuration
```bash
cp .env.example .env
# Éditer .env
```

**Important v0.1.1 :** Ajouter DB_PORT si port non standard
```ini
DB_HOST=serveur.mysql.db
DB_PORT=35307  # Port personnalisé OVH CloudDB
DB_NAME=alescity
DB_USER=alescity
DB_PASSWORD=***
```

### 5. Email
Créer noreply@votre-domaine.com dans panneau OVH

### 6. Composer
```bash
composer install --no-dev
```

### 7. Permissions
```bash
chmod 755 public/uploads logs
find public/uploads -type d -exec chmod 755 {} \;
```

### 8. DNS
Configurer SPF, DKIM, DMARC (voir README.md)

### 9. Vérifier
```bash
php check_install.php
```

### 10. Accéder
https://votre-domaine.com → Page "Installation réussie"

## ✅ Checklist

- [ ] Fichiers uploadés
- [ ] Domaine pointe vers /public
- [ ] Base MySQL créée (18 tables)
- [ ] .env configuré avec DB_PORT
- [ ] Email noreply@ créé
- [ ] Composer installé
- [ ] Permissions OK
- [ ] DNS configuré
- [ ] check_install.php ✓
- [ ] Site accessible

**Prêt ! 🎉**
